/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.util;

import com.mojang.serialization.Lifecycle;
import io.github.apace100.origins.util.ArchitecturyWrappedRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import me.shedaniel.architectury.registry.Registries;
import me.shedaniel.architectury.registry.Registry;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.MutableRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaWrappedRegistry<S>
extends MutableRegistry<S> {
    private final Function<Registries, Registry<S>> toArchRegistry;
    private final Lifecycle lifecycle;
    private final Registry<S> archRegistry;
    private final Map<S, Lifecycle> entryToLifecycle;
    private final Map<String, Registry<S>> archRegistries;

    public static <T> VanillaWrappedRegistry<T> wrap(Registry<T> arch) {
        return VanillaWrappedRegistry.wrap(arch, Lifecycle.stable());
    }

    public static <T> VanillaWrappedRegistry<T> wrap(Registry<T> arch, Lifecycle lifecycle) {
        Function toArch = s -> s.get(arch.key());
        return new VanillaWrappedRegistry<T>(arch, toArch, lifecycle);
    }

    public static <T, S> VanillaWrappedRegistry<T> wrap(Registry<T> arch, Function<T, S> to, Function<S, T> from) {
        return VanillaWrappedRegistry.wrap(arch, to, from, Lifecycle.stable());
    }

    public static <T, S> VanillaWrappedRegistry<T> wrap(Registry<T> arch, Function<T, S> to, Function<S, T> from, Lifecycle lifecycle) {
        RegistryKey key = arch.key();
        Function<Registries, Registry<S>> toArch = s -> new ArchitecturyWrappedRegistry(s.get(key), to, from);
        return new VanillaWrappedRegistry<T>(arch, toArch, lifecycle);
    }

    public VanillaWrappedRegistry(Registry<S> archRegistry, Function<Registries, Registry<S>> toArchRegistry, Lifecycle lifecycle) {
        super(archRegistry.key(), lifecycle);
        this.archRegistry = archRegistry;
        this.toArchRegistry = toArchRegistry;
        this.lifecycle = lifecycle;
        this.entryToLifecycle = new HashMap<S, Lifecycle>();
        this.archRegistries = new HashMap<String, Registry<S>>();
    }

    @Nullable
    public ResourceLocation func_177774_c(S object) {
        return this.archRegistry.getId(object);
    }

    public Optional<RegistryKey<S>> func_230519_c_(S object) {
        return this.archRegistry.getKey(object);
    }

    public int func_148757_b(@Nullable S object) {
        return this.archRegistry.getRawId(object);
    }

    @Nullable
    public S func_148745_a(int i) {
        return (S)this.archRegistry.byRawId(i);
    }

    @Nullable
    public S func_230516_a_(@Nullable RegistryKey<S> registryKey) {
        return this.func_82594_a(registryKey == null ? null : registryKey.func_240901_a_());
    }

    @Nullable
    public S func_82594_a(@Nullable ResourceLocation identifier) {
        return (S)this.archRegistry.get(identifier);
    }

    protected Lifecycle func_241876_d(S object) {
        return this.entryToLifecycle.getOrDefault(object, Lifecycle.stable());
    }

    public Lifecycle func_241875_b() {
        return this.lifecycle;
    }

    public Set<ResourceLocation> func_148742_b() {
        return this.archRegistry.getIds();
    }

    public Set<Map.Entry<RegistryKey<S>, S>> func_239659_c_() {
        return this.archRegistry.entrySet();
    }

    public boolean func_212607_c(ResourceLocation identifier) {
        return this.archRegistry.contains(identifier);
    }

    @NotNull
    public Iterator<S> iterator() {
        return this.archRegistry.iterator();
    }

    public <V extends S> V func_218382_a(int i, RegistryKey<S> registryKey, V object, Lifecycle lifecycle) {
        throw new UnsupportedOperationException("Set is unsupported on wrapped registries.");
    }

    public <V extends S> V func_218381_a(RegistryKey<S> registryKey, V object, Lifecycle lifecycle) {
        this.archRegistries.computeIfAbsent(registryKey.func_240901_a_().func_110624_b(), x -> this.toArchRegistry.apply(Registries.get((String)x))).registerSupplied(registryKey.func_240901_a_(), () -> object);
        this.entryToLifecycle.put(object, lifecycle);
        return object;
    }

    public <V extends S> V func_241874_a(OptionalInt optionalInt, RegistryKey<S> registryKey, V object, Lifecycle lifecycle) {
        throw new UnsupportedOperationException("Replace is unsupported on wrapped registries.");
    }
}

